%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      InitializeProject.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% File Version:   1
% Description:    This file initializes all project settings and parameters.
%                 Anything global parameters are to be defined in this file.
%-------------------------------------------------------------------------------

%-------------------------------------------------------------------------------
%                                  General
%-------------------------------------------------------------------------------
TRUE = 1;
FALSE = 0;
showISET = TRUE;

%-------------------------------------------------------------------------------
%                              Scene Definitions
%-------------------------------------------------------------------------------
numCandelas = 300;          % candelas measured at target (100)
distanceToTarget = 1;      % meters to target (1)
fieldOfView = 26.5;        % field of view (26.5)

%-------------------------------------------------------------------------------
%                             Optics Definitions
%-------------------------------------------------------------------------------
fNumber = 4;
focalLength = 2*10^(-3);

%-------------------------------------------------------------------------------
%                             Sensor Definitions
%-------------------------------------------------------------------------------
minWavelength = 400;
maxWavelength = 710;
waveLengths = minWavelength:5:maxWavelength;
voltageSwing   = 1.15;     % Volts
wellCapacity   = 9000;     % Electrons
conversiongain = voltageSwing/wellCapacity;   
fillfactor     = 0.45;     % A fraction of the pixel area
pixelSize      = 2.2*1e-6; % Meters
darkvoltage    = 0.0;      % Volts/sec (1e-005)
readnoise      = 0.0;      % Volts (0.00096)

exposureDuration = 0.030;  % Seconds
dsnu =  0;                 % Volts (0.001)
prnu = 0;                  % Percent (ranging between 0 and 100) - (0.2218)
analogGain   = 1;          % Used to adjust ISO speed
analogOffset = 0;          % Used to account for sensor black level
%rows = 466;                % number of pixels in a row
%cols = 642;                % number of pixels in a column

% End of File
